% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_make_unique}
\alias{whapi_make_unique}
\title{Make identifiers unique while preserving order}
\usage{
whapi_make_unique(x)
}
\arguments{
\item{x}{A character vector of IDs (possibly with duplicates).}
}
\value{
A character vector of the same length with unique IDs.
}
\description{
Ensures that a character vector of identifiers is unique by appending
numeric suffixes (\verb{_2}, \verb{_3}, ...) when duplicates are found, while
preserving the original order.
}
\details{
This helper is particularly useful when generating button IDs for
WhatsApp interactive messages via Whapi. Even after whapi_slugifying labels,
duplicates may remain (e.g., two buttons both titled \code{"Yes"}).
The function guarantees uniqueness by incrementally appending a suffix.

Algorithm:
\itemize{
\item Iterates through \code{x} in order;
\item Keeps a counter of how many times each ID has appeared;
\item First occurrence is left unchanged;
\item Subsequent duplicates get suffixed with \verb{_<n>}.
}
}
\examples{
whapi_make_unique(c("yes", "no", "yes", "yes", "maybe", "no"))
# -> "yes", "no", "yes_2", "yes_3", "maybe", "no_2"

# Combined with whapi_slugify
titles <- c("Yes!", "Yes!", "No?")
ids <- whapi_make_unique(whapi_slugify(titles))
tibble::tibble(title = titles, id = ids)

}
\seealso{
\code{\link[=whapi_slugify]{whapi_slugify()}} for slug-safe ID creation.
}
