% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{whapi_parse_command}
\alias{whapi_parse_command}
\title{Parse a text message into command and arguments (Whapi helper)}
\usage{
whapi_parse_command(text, collapse_args = TRUE)
}
\arguments{
\item{text}{A character string containing the full message (e.g. \code{"/groe ajuda"}).}

\item{collapse_args}{Logical, default \code{TRUE}. If \code{TRUE}, all arguments are
collapsed into a single space-separated string. If \code{FALSE}, arguments are
returned as a character vector of tokens.}
}
\value{
A list with two elements:
\describe{
\item{\code{command}}{The command string (first token), trimmed (e.g. \code{"/groe"}).}
\item{\code{arguments}}{The arguments, either collapsed as a single string
(default) or as a character vector, depending on \code{collapse_args}.}
}
}
\description{
Splits an incoming text (usually from a WhatsApp message) into a \strong{command}
(the first token, starting with \code{/}) and its associated \strong{arguments}.
Supports collapsing arguments into a single string or preserving them as
a character vector.
}
\examples{
whapi_parse_command("/groe ajuda")
#> $command
#> [1] "/groe"
#>
#> $arguments
#> [1] "ajuda"

whapi_parse_command("/groe nome empresa", collapse_args = FALSE)
#> $command
#> [1] "/groe"
#>
#> $arguments
#> [1] "nome" "empresa"

}
\seealso{
\code{\link[stringr:str_extract]{stringr::str_extract()}}, \code{\link[stringr:str_split]{stringr::str_split()}}
}
