% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dv.vs.pred.ipred.R
\name{dv.vs.pred.ipred}
\alias{dv.vs.pred.ipred}
\title{Observations (DV) are plotted against individual predictions (IPRED) and
population predictions (PRED), for Xpose 4}
\usage{
dv.vs.pred.ipred(
  object,
  xlb = "Predictions",
  layout = c(2, 1),
  abline = c(0, 1),
  lmline = TRUE,
  smooth = NULL,
  scales = list(),
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{xlb}{A string giving the label for the x-axis. \code{NULL} if none.}

\item{layout}{A list giving the layout of the graphs on the plot, in columns
and rows.}

\item{abline}{Vector of arguments to the \code{\link[lattice]{panel.abline}}
function. No abline is drawn if \code{NULL}.}

\item{lmline}{logical variable specifying whether a linear regression line
should be superimposed over an \code{\link[lattice]{xyplot}}. \code{NULL} ~
FALSE. (\code{y~x})}

\item{smooth}{\code{NULL} or \code{TRUE} value indicating whether an x-y
smooth should be superimposed.}

\item{scales}{A list to be used for the \code{scales} argument in
\code{xyplot}.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}}.}
}
\value{
Returns a compound plot comprising plots of observations (DV)
against individual predictions (IPRED) and population predictions (PRED).
}
\description{
This is a compound plot consisting of plots of observations (DV) against
individual predictions (IPRED) and population predictions (PRED), a specific
function in Xpose 4. It is a wrapper encapsulating arguments to the
\code{xpose.plot.default} function.
}
\details{
Plots of DV vs PRED and IPRED are presented side by side for comparison.

A wide array of extra options controlling \code{xyplot}s are available. See
\code{\link{xpose.plot.default}} and \code{\link{xpose.panel.default}} for
details.
}
\examples{
dv.vs.pred.ipred(simpraz.xpdb)

}
\seealso{
\code{\link{dv.vs.pred}}, \code{\link{dv.vs.ipred}},
\code{\link{xpose.plot.default}}, \code{\link{xpose.panel.default}},
\code{\link[lattice]{xyplot}}, \code{\link{xpose.prefs-class}},
\code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.pred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{gof}()},
\code{\link{ind.plots}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\concept{specific functions}
\keyword{methods}
