% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootgam.plots.R
\name{xp.incl.index.cov}
\alias{xp.incl.index.cov}
\title{Plot of inclusion index of covariates.}
\usage{
xp.incl.index.cov(
  bootgam.obj = NULL,
  boot.type = NULL,
  main = NULL,
  xlb = "Index",
  ylb = "Covariate",
  add.ci = FALSE,
  incl.range = NULL,
  return_plot = TRUE,
  results.tab = NULL,
  ...
)
}
\arguments{
\item{bootgam.obj}{The bootgam or bootscm object.}

\item{boot.type}{Either "bootgam" or "bootscm". Default is NULL, which means
the user will be asked to make a choice.}

\item{main}{Plot title.}

\item{xlb}{Label for the x-axis.}

\item{ylb}{Label for the y-axis.}

\item{add.ci}{Add a confidence interval to the plotted data.}

\item{incl.range}{Included range}

\item{return_plot}{Should the function return a plot?}

\item{results.tab}{Specify your own results table.}

\item{...}{Additional plotting information.}
}
\value{
A lattice plot object is returned.
}
\description{
Covariate inclusion indices show the correlation in inclusion of a covariate
in the final model in a bootgam or bootscm.
}
\seealso{
Other bootgam: 
\code{\link{xp.daic.npar.plot}()},
\code{\link{xp.dofv.npar.plot}()},
\code{\link{xp.inc.cond.stab.cov}()},
\code{\link{xp.inc.ind.cond.stab.cov}()},
\code{\link{xp.inc.stab.cov}()},
\code{\link{xp.incl.index.cov.ind}()}

Other bootscm: 
\code{\link{bootscm.import}()},
\code{\link{xp.daic.npar.plot}()},
\code{\link{xp.dofv.npar.plot}()},
\code{\link{xp.inc.cond.stab.cov}()},
\code{\link{xp.inc.ind.cond.stab.cov}()},
\code{\link{xp.inc.stab.cov}()},
\code{\link{xp.incl.index.cov.ind}()}
}
\author{
Ron Keizer
}
\concept{bootgam}
\concept{bootscm}
