
f.acf <- function(series, lag.max = 10*log10(length(series)), ...)
{
  ## Purpose:  time series plot with correlograms
  ## -------------------------------------------------------------------------
  ## Arguments: series : time series
  ##           lag.max : the maximum number of lags for the correlograms
  ## -------------------------------------------------------------------------
  ## Author: Markus Huerzeler, Date: 15 Jun 94, 
  ## Revision: Christian Keller, 5 May 98, 
  ##           Markus Huerzeler, 11 Mar 02, Anpassung an R
  old.par <- par(mar=c(3,3,1,1), mgp=c(1.5,0.5,0), mfrow=c(1,1))
  split.screen(figs=matrix(c(0,1,0.33,1, 0,0.5,0,0.33, 0.5,1,0,0.33),
                 ncol=4, byrow=T))
  ##screen(1)
  plot.ts(series, cex=0.7, ...)
  screen(2)
  g.plot.acf(series, cex=0.7, lag.max=lag.max)
  screen(3)
  g.plot.acf(series, type="partial", ylab="part. Autokorr", cex=0.7, lag.max=lag.max)
  close.screen(all=T)
  invisible(par(old.par))
}


g.plot.acf <- function(series, type="corr", ylab="Auto-Korr.", lag.max=10*log10(length(series)), ...)
{
  ## Author: Markus Huerzeler, Date:  6 Jun 94
  ## Revision: Christian Keller, 27 Nov 98
  ## Revision: Markus Hrzeler, 11 Mar 02
  erg <- acf(series, type=type, plot=F, lag.max=lag.max,na.action=na.omit)
  
  erg.acf <- erg$acf
  erg.konf <- 2/sqrt(erg$n.used)
  yli <- range(c(erg.acf, erg.konf, -erg.konf))*c(1.1, 1.1)
  erg.lag <- as.vector(erg$lag)

  ## Labels fuer x-Achse definieren:
  ## 1. Label ist immer erg.lag[1]
  pos <- pretty(erg.lag)
  n <- length(pos)
  d <- pos[2] - pos[1] ; f <- pos[1]-erg.lag[1]
  pos <- c(erg.lag[1], pos[1][f > d/2], pos[2:n])

  plot(erg.lag, erg.acf, type="h", ylim=yli, xlab="Lag k", ylab=ylab,
       xaxt="n", ...)
  axis(1, at=pos, ...)
  abline(0,0)
  abline(h=c(erg.konf, - erg.konf), lty=2)
  invisible()
}

