## Funktionen zur Cluster-Analyse
## ------------------------------

# require(cluster)

f.agnes <- function(data, group, distance="euclidean", method="average",
		      k=2, plot=TRUE, main=tit, ...) 
{
  ## Purpose: hierarchical Clustering
  ## ------------------------------------------------------------------
  ## Arguments:  data : Datenmatrix oder Data Frame
  ##            group : schon bekannte Gruppenzugehoerigkeit
  ##         distance : zu gebrauchendes Distanzmass:
  ##                    'euclidean', 'maximum', 'manhatten', 'binary' ,...
  ##             meth : Clustermethode:
  ##                                   'single'   (= single linkage)
  ##                                   'average'
  ##                                   'complete'  (= complete linkage)
  ##                                   ........
  ##                k : gewnschte Anzahl Gruppen
  ##             plot : falls T wird ein Dendrogramm gezeichnet  
  ## ------------------------------------------------------------------
  ## Author: Markus Huerzeler, Christian Keller
  ## Update: 13. Nov. 2003, R. Frisullo
  erg.hcl  <- agnes(data, metric = distance, method=method)

  tit <- paste("Methode: `", method, "', Distanz: `", distance, "'", sep="")
  #  'title' berschreibt den Titel von 'plot'
  #  if(plot) { plot(erg.hcl, ...); title(main=main, ...) }
  if(plot) { plot(erg.hcl, main=main, ...) }

  erg.cut <- cutree(erg.hcl, k=k)
  cat("\nHierarchisches Clustering:", tit) 
  cat("\nKlassifikation:\n")
  print(table(group, erg.cut))
  
  invisible(erg.cut)
}


f.pam <- function(data, group, distance = "euclidean", k = 2)
{
## Purpose:  k-means Clustering Methode
## ------------------------------------------------------------------
## Arguments:  data : Datenmatrix oder Data Frame
##            group : schon bekannte Gruppenzugehoerigkeit
##                k : gewnschte Anzahl Gruppen
## folgende Argumente werden fuer die Bestimmung der Startwerte der
## Zentren benuetzt:
##             dist : zu gebrauchendes Distanzmass:
##                    'euclidean', 'maximum', 'manhatten', 'binary' 
##             meth : Clustermethode:
##                                   'average'
##                                   'ward'
##                                   'connected'   (= single linkage)
## ------------------------------------------------------------------
## Author: Markus Huerzeler, Christian Keller, Monika Ferster

	erg.k <- pam(daisy(data,metric=distance),k=k,diss=T)
	cat("\nK-medoid (PAM) Clustering:")
	cat("\nKlassifikation:\n")
	print(table(group, erg.k$cluster))
	invisible(erg.k$cluster)
}


plot.PCclust <- function(clust.res, data, labels=clust.res, col=clust.res,
			 main=deparse(substitute(clust.res)), ...)
{
  ## Purpose: Cluster in Hauptkomponenten-Koordinaten
  ## -------------------------------------------------------------------------
  ## Arguments: clust.res : Resultat aus f.agnes() oder f.pam()
  ##                        [oder f.cluster oder f.kmean]
  ##                 data : Datenmatrix oder Data Frame
  ## -------------------------------------------------------------------------
  ## Author: Martin Maechler, Christian Keller

  pr12 <- prcomp(data)$x[,1:2]
  plot(pr12, xlab="1. Hauptkomponenten-Achse", ylab="2. Hauptkomponenten-Achse",
       type="n", main=main, ...)
  text(pr12, labels=labels, col=col, ...)
}

