#   Library geoR laden
library(geoR)

#   Definition des Gitters, fr welche Werte simuliert werden sollen.
t.x <- seq(from = 0.00333333333, to = 1., by = 0.00333333333)
t.y <- 1
t.n <- length(t.x) * length(t.y)
t.grid <- as.matrix(expand.grid(t.x, t.y))      # 1-dimensionales Gitter

### Teilaufgabe a:
#   Definition des Variogramms, das fr die Simulation verwendet werden soll
t.sill  <- 1                   # Sill des Variogramms
t.range <- 0.15                # Range (Skalenparameter) des Variogramms
t.nsr   <- 0                   # Verhltnis von Nugget zu Sill
#   Berechnung weiterer Grssen, die fr die Simulation bentigt werden
t.cov.pars <- c(t.sill * (1 - t.nsr), t.range)
t.nugget   <- t.sill * t.nsr
#   Simulation
d.sim <- grf(n= t.n, grid= t.grid, cov.model= "spherical", cov.pars= t.cov.pars,
             nugget= t.nugget, nsim= 2)
plot(d.sim$coords[,1],  d.sim$data[,1], ylim = c(-4, 4),
     xlab = "Koordinate s", ylab = "Realisierung y(s)", pch = 16, cex = 0.2,
     main = paste("Modell: ", d.sim$cov.model, ", Sill: ", d.sim$cov.pars[1],
       ", Range: ", d.sim$cov.pars[2], ", Nugget: ", d.sim$nugget, sep=""))
points(d.sim$coords[ ,1], d.sim$data[ ,2], col = 2, cex = 0.2, pch = 16)

#   Graphen des Variogramms zeichnen
plot(t.x, t.sill-cov.spatial(obj=t.x, cov.model="spherical", cov.pars=t.cov.pars),
     type="l", cex.axis=0.7, xlab="", ylab="", ylim=c(0,t.sill*1.2))

### Teilaufgabe b:
par(mfrow=c(2,2))
for (t.nsr in c(0.05, 0.5)){
t.cov.pars <- c(t.sill * (1 - t.nsr), t.range)
t.nugget   <- t.sill   * t.nsr
d.sim <- grf(n= t.n, grid= t.grid, cov.model= "spherical", cov.pars= t.cov.pars,
             nugget= t.nugget, nsim= 2)
plot(d.sim$coords[,1], d.sim$data[,1], ylim= c(-4, 4), xlab= "Koordinate s",
     ylab= "Realisierung y(s)", pch= 16, cex= 0.2)
title(paste("Modell: ", d.sim$cov.model, sep=""), line=2)
title(list(paste("Range: ", d.sim$cov.pars[2], ", Sill: ", d.sim$cov.pars[1],
                 ", Nugget: ", d.sim$nugget, sep=""), cex=1), line=1)
points(d.sim$coords[,1], d.sim$data[,2], col= 2, cex= 0.2, pch= 16)
plot(t.x, t.sill-cov.spatial(obj= t.x, cov.model= "spherical", cov.pars= t.cov.pars),
     type= "l", cex.axis= 0.7, xlab= "", ylab= "", ylim= c(0, t.sill * 1.2))}
par(mfrow=c(1,1))

### Teilaufgabe c:
#   Definition des Variogramms, das fr Simulation verwendet werden soll
t.sill  <- 1                  # Sill des Variogramms
t.range <- 0.05               # Range (Skalenparameter) des Variogramms
t.nsr   <- 0                  # Verhltnis von Nugget zu Sill
t.kappa <- 1.25               # "Glattheits"-Parameter delta
#   Berechnung weiterer Grssen die fr die Simulation bentigt werden
t.cov.pars <- c(t.sill * (1 - t.nsr), t.range)
t.nugget   <- t.sill * t.nsr
#   Realisierungen simulieren
d.sim <- grf(n = t.n, grid = t.grid, cov.model = "matern",  cov.pars = t.cov.pars,
             nugget = t.nugget, kappa = t.kappa, nsim = 2)
#   simulierte Realisierungen darstellen
par(fig = c(0, 1, 0, 1), new = FALSE)
plot(d.sim$coords[,1], d.sim$data[,1], cex= 0.2, pch= 16,
     ylim= c(-4,4), xlab= "Koordinate s", ylab= "Realisierung y(s)",
     main = paste("Modell: ", d.sim$cov.model, ", Range: ", d.sim$cov.pars[2], ", Sill: ",
       d.sim$cov.pars[1], ", Nugget: ", d.sim$nugget, ", Delta: ", d.sim$kappa, sep=""))
points(d.sim$coords[,1], d.sim$data[,2], col = 2, cex = 0.2, pch = 16)
#   Graphen des Variogramms zeichnen
plot(t.x, t.sill-cov.spatial(obj= t.x, cov.model= "matern",
                             cov.pars= t.cov.pars, kappa= t.kappa),
     type = "l", cex.axis = 0.7, xlab = "", ylab = "", ylim = c(0, t.sill * 1.2))

### Teilaufgabe d:
#   Definition des Variogramms, das fr Simulation verwendet werden soll
t.sill  <- 1       # Sill des Variogramms
t.range <- 0.05    # Range (Skalenparameter) des Variogramms
t.nsr   <- 0.35    # Verhltnis von Nugget zu Sill
t.kappa <- 2       # "Glattheits"-Parameter delta
#   Berechnung weiterer Grssen die fr die Simulation bentigt werden
t.cov.pars <- c(t.sill * (1 - t.nsr), t.range)
t.nugget   <- t.sill * t.nsr
#   Realisierungen simulieren
d.sim <- grf(n = t.n, grid = t.grid, cov.model = "matern",  cov.pars = t.cov.pars,
             nugget = t.nugget, kappa = t.kappa, nsim = 2)
#   simulierte Realisierungen darstellen
par(fig = c(0, 1, 0, 1), new = FALSE)
plot(d.sim$coords[,1], d.sim$data[,1], cex= 0.2, pch= 16,
     ylim = c(-4, 4), xlab = "Koordinate s", ylab = "Realisierung y(s)",
     main = paste("Modell: ", d.sim$cov.model, ", Range: ", d.sim$cov.pars[2], ", Sill: ",
       d.sim$cov.pars[1], ", Nugget: ", d.sim$nugget, ", Delta: ", d.sim$kappa, sep=""))
points(d.sim$coords[,1], d.sim$data[,2], col = 2, cex = 0.2, pch = 16)
#   Graphen des Variogramms zeichnen
plot(t.x, t.sill-cov.spatial(obj = t.x, cov.model = "matern",
                             cov.pars = t.cov.pars, kappa = t.kappa),
     type = "l", cex.axis = 0.7, xlab = "", ylab = "", ylim = c(0, t.sill * 1.2))


